/**
 * Some documents:
 *  * https://www.linkedin.com/pulse/dont-ghost-technical-guide-implementing-consent-mode-gtm-thomsen-gehee/
 *  * https://support.google.com/analytics/answer/9976101?sjid=17653893811495837196-EU
 *  * https://tagassistant.google.com/
 */

(function(JSINFO) {

    if (!JSINFO) {
        return;
    }

    function googleAnalytics($rootScope) {

        window.dataLayer = window.dataLayer || [];
        window.gtag = function() { dataLayer.push(arguments); }
        gtag('config', JSINFO.gtagId);
        gtag('consent', 'default', {
            'ad_user_data': 'denied',
            'ad_personalization': 'denied',
            'ad_storage': 'denied',
            'analytics_storage': 'denied',
            'wait_for_update': 500,
        });
        gtag('js', new Date());

        /** wrapping GA functions */
        window.ga = function() {
            if (typeof window.gtag === 'function' && arguments[0] === 'send' && arguments[1] === 'event') {
                window.gtag('event', arguments[3], {
                    event_category: arguments[2],
                    event_label: arguments[4],
                });
            }
        };

        var consentGiven = function() {
            typeof window.gtag === 'function' && gtag('consent', 'update', {
                ad_user_data: 'granted',
                ad_personalization: 'granted',
                ad_storage: 'granted',
                analytics_storage: 'granted'
            });
        };

        var consentDenied = function() {
            typeof window.gtag === 'function' && gtag('consent', 'update', {
                ad_user_data: 'denied',
                ad_personalization: 'denied',
                ad_storage: 'denied',
                analytics_storage: 'denied'
            });
        };

        var getTemplateOrPluginOption = function(key) {
            return $rootScope.getMsg('googleanalytics.' + key);
        };

        $.cookieBar({
            fixed: true,
            autoEnable: false,
            bottom: true,
            forceShow: true,
            append: true,

            message: getTemplateOrPluginOption('acceptBody'),
            acceptText: getTemplateOrPluginOption('acceptButton'),
            acceptButton: !!getTemplateOrPluginOption('acceptButton'),
            declineText: getTemplateOrPluginOption('declineButton'),
            declineButton: !!getTemplateOrPluginOption('declineButton'),
            policyText: getTemplateOrPluginOption('policyButton'),
            policyButton: !!getTemplateOrPluginOption('policyButton'),
            policyURL: getTemplateOrPluginOption('policyURL'),
            acceptOnContinue: false,
            acceptOnScroll: false,
            acceptAnyClick: false,
            expireDays: 30,
            renewOnVisit: false,
            forceShow: false,

            acceptFunction: consentGiven,
            declineFunction: consentDenied,

            element: '.content',
        });

        (function(w, d, s, l, i) {
            w[l] = w[l] || []; w[l].push({ 'gtm.start': new Date().getTime(), event: 'gtm.js' });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s), dl = l != 'dataLayer' ? '&l=' + l : ''; j.async = true;
            j.src = '//www.googletagmanager.com/gtm.js?id=' + i + dl; f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', window.dataLayer[0][1]);

        $.cookieBar('cookies') && consentGiven('true');

        $rootScope.$on('$locationChangeSuccess', function() {
            // track pageview and action
            ga('set', 'page', location.pathname);
            ga('send', 'pageview');
        });
    };

    googleAnalytics.$inject = ['$rootScope'];
    clearreportsApp.run(googleAnalytics);

})(window.GOGINFO);
